#include "ScreenQuadPS_Rm.hlsl"
static const float MainSpheRadius = 4;//5.65; // 0.5 * squareroot(2) * HalfLedCubeSide;


int fToLedIndex(in float3 pos)
{
    int3 indexes = floor(pos);
    return indexes.x + indexes.y *LedCubeSide + indexes.z * LedCubeSide *  LedCubeSide ;
}
float MetaBallsIntensityAt(in float3 pos)
{
     int index = fToLedIndex(pos);
    if(index < 0 || index > 4095)
        return -1;

    return Intensity[index >> 2][index & 3];
}

float4 main( PS_INPUT input) : SV_Target
{
    class MetaBallsDomain : LedDomain 
    { 
       bool IsOutside(in float3 p)
        {
            return any(p > LedCubeSide ) || any(p < 0 );
        }
    } metaBallsDomain;

    class MetaBalls : IntensityProvider 
    {
        float IntensityAt(float3 p) 
        {
             // fade in
            if(SequenceRatio < 0.1)
            {
                float smooth = smoothstep(0, 0.1, SequenceRatio);
                //p.y += HalfLedCubeSide *(1 -smoothstep(0, 0.1, SequenceRatio));
                return (-1 + smooth) + smooth* MetaBallsIntensityAt(p) ;
            }

            if(SequenceRatio < 0.9)
                return MetaBallsIntensityAt(p);
   
            // fade out
            
            float smooth = 1-smoothstep(0.9, 1., SequenceRatio);
            //p.y += HalfLedCubeSide *(1 -smoothstep(0, 0.1, SequenceRatio));
            return (-1 + smooth) + smooth* MetaBallsIntensityAt(p) ;            
        }

    } metaBallsScene ;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
            // UV --> input.Text.xy e [0 1]
            /*
            o---------X
            |
            |
            |
            |
            Y
            */

                      // Pixel position
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation

            float3 rayOrigin    = (float3)HalfLedCubeSide;
            rayOrigin.z = 2 * LedCubeSide ;
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -2));
    
            float t = SequenceRatio* 2 * Pi;
            rayOrigin = HalfLedCubeSide+ rotateY(rayOrigin - HalfLedCubeSide , t);
            rayDirection =  rotateY(rayDirection, t);


            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, metaBallsScene, metaBallsDomain);
}